package ru.yandex.direct.bsexport.messaging.processors;

import java.util.function.BiFunction;

import com.google.common.primitives.UnsignedLong;
import org.w3c.dom.Node;

class UnsignedLongFieldProcessor<B> extends FieldProcessor<B, Long> {

    UnsignedLongFieldProcessor(BiFunction<B, Long, B> setter) {
        super(setter, UnsignedLongFieldProcessor::parseLong);
    }

    private static long parseLong(Node node) {
        return UnsignedLong.valueOf(node.getTextContent()).longValue();
    }
}
