package ru.yandex.direct.bsexport.model;

import java.util.Map;
import java.util.Objects;

public class SoapFault {
    private String faultCode;
    private String faultString;
    private Map<String, String> faultDetails;

    public SoapFault withFaultCode(String faultCode) {
        this.faultCode = faultCode;
        return this;
    }

    public SoapFault withFaultString(String faultString) {
        this.faultString = faultString;
        return this;
    }

    public SoapFault withFaultDetails(Map<String, String> faultDetails) {
        this.faultDetails = faultDetails;
        return this;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("SoapFault{");
        sb.append("faultCode='").append(faultCode).append('\'');
        sb.append(", faultString='").append(faultString).append('\'');
        sb.append(", faultDetails=").append(faultDetails);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SoapFault soapFault = (SoapFault) o;
        return Objects.equals(faultCode, soapFault.faultCode) &&
                Objects.equals(faultString, soapFault.faultString) &&
                Objects.equals(faultDetails, soapFault.faultDetails);
    }

    @Override
    public int hashCode() {
        return Objects.hash(faultCode, faultString, faultDetails);
    }
}
