package ru.yandex.direct.bsexport.util;

import com.google.common.base.Joiner;

import ru.yandex.adv.direct.expression.TargetingExpression;
import ru.yandex.adv.direct.expression.TargetingExpressionAtom;
import ru.yandex.direct.bsexport.model.Context;
import ru.yandex.direct.bsexport.model.ContextOrBuilder;
import ru.yandex.direct.bsexport.model.Order;
import ru.yandex.direct.bsexport.model.OrderOrBuilder;
import ru.yandex.direct.bsexport.model.UpdateData2Request;

public class QueryComposer {
    private static final Joiner KEY_JOINER = Joiner.on('_');

    private QueryComposer() {
    }

    public static void putOrder(UpdateData2Request.Builder requestBuilder, Order order) {
        String key = getOrderKey(order);
        requestBuilder.putORDER(key, order);
    }

    public static void putContext(Order.Builder orderBuilder, Context context) {
        String key = getContextKey(context);
        orderBuilder.putCONTEXT(key, context);
    }

    public static String getOrderKey(OrderOrBuilder order) {
        return KEY_JOINER.join('O', order.getID(), order.getEID());
    }

    public static String getContextKey(ContextOrBuilder context) {
        return KEY_JOINER.join('C', context.getID(), context.getEID());
    }

    public static TargetingExpression.Disjunction.Builder disjunctionBuilder(TargetingExpressionAtom expressionAtom) {
        return TargetingExpression.Disjunction.newBuilder()
                .addOR(expressionAtom);
    }
}
