package ru.yandex.direct.bvm.client;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.geosmb.bvm.model.FetchBizIdProtobuf;

import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class BvmClient {

    private final BvmApi bvmApi;

    public BvmClient(BvmConfiguration configuration, ParallelFetcherFactory fetcherFactory) {
        bvmApi = Smart.builder()
                .withParallelFetcherFactory(fetcherFactory)
                .withProfileName("bvm_client")
                .withBaseUrl(configuration.getApiUrl())
                .build()
                .create(BvmApi.class);
    }

    public FetchBizIdProtobuf.FetchNoCreateBizIdOutput fetchNoCreateBizId(
            FetchBizIdProtobuf.FetchNoCreateBizIdInput input
    ) {
        var call = bvmApi.fetchNoCreateBizId(input);
        var result = call.execute();
        checkResultForErrors(result, BvmApiException::new);
        return result.getSuccess();
    }

    public FetchBizIdProtobuf.FetchBizIdOutput fetchBizId(
            FetchBizIdProtobuf.FetchBizIdInput input
    ) {
        var call = bvmApi.fetchBizId(input);
        var result = call.execute();
        checkResultForErrors(result, BvmApiException::new);
        return result.getSuccess();
    }
}
