package ru.yandex.direct.libs.cachingutils;

import java.util.Collections;

import javax.annotation.Nonnull;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;

import ru.yandex.direct.solomon.SolomonUtils;

public abstract class DirectLoadingCache<K, V> {
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private final LoadingCache<K, V> loadingCache;

    public DirectLoadingCache() {
        this(DEFAULT_CACHE_SIZE);
    }

    public DirectLoadingCache(int size) {
        loadingCache = CacheBuilder.newBuilder()
                .recordStats()
                .maximumSize(size)
                .build(
                        new CacheLoader<K, V>() {
                            public V load(K key) {
                                return getValue(key);
                            }
                        });

        SolomonUtils.registerGuavaCachesStats(
                solomonSensorName(),
                Collections.singletonList(loadingCache)
        );
    }

    public V getCached(K key) {
        return loadingCache.getUnchecked(key);
    }

    abstract protected V getValue(K key);

    @Nonnull
    abstract protected String solomonSensorName();
}
