package ru.yandex.direct.canvas.client.model;

import java.util.Locale;

import org.asynchttpclient.RequestBuilder;

import static io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_JSON;

public abstract class CanvasRequest<T> {
    private String path;
    private String contentType = APPLICATION_JSON.toString();
    private Locale locale;

    public String getPath() {
        return this.path;
    }

    public String getContentType() {
        return contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract void prepareRequest(RequestBuilder request);

    public abstract T deserializeResponse(String resp);

    public void setPath(String path) {
        this.path = path;
    }

    // Этот путь не должен содержать id, логина, для всех должен быть одинаковым
    public abstract String getMetricsPath();

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}
