package ru.yandex.direct.canvas.client.model.exception;

import java.util.ArrayList;
import java.util.List;

public class CanvasClientException extends RuntimeException {
    private List<String> validationErrors;

    public CanvasClientException(String message) {

        super(message);

        this.validationErrors = new ArrayList<>();
    }

    public CanvasClientException(String message, List<String> validationErrors) {
        super(message);

        this.validationErrors = validationErrors;
    }

    public CanvasClientException(Throwable cause) {
        super(cause);
    }

    public List<String> getValidationErrors() {
        return validationErrors;
    }
}
