package ru.yandex.direct.canvas.client.model.ffmpegresolutions;

import java.util.List;

import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static java.util.Arrays.asList;
import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class GetFfmpegResolutionsRequest extends CanvasRequest<List<FfmpegResolutionsResponse>> {
    private static final String PATH = "ffmpeg-resolutions";

    private FfmpegResolutionsRequestType ffmpegResolutionsType;

    public GetFfmpegResolutionsRequest(FfmpegResolutionsRequestType ffmpegResolutionsType) {
        this.ffmpegResolutionsType = ffmpegResolutionsType;
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("type", ffmpegResolutionsType.name());
    }

    public List<FfmpegResolutionsResponse> deserializeResponse(String resp) {
        return asList(fromJson(resp, FfmpegResolutionsResponse[].class));
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
