package ru.yandex.direct.canvas.client.model.html5;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

public class CreateHtml5BatchRequest extends CanvasRequest<Html5BatchResponse> {
    private static final String PATH = "html5/internal-batch";

    private final Long clientId;
    private final String name;
    private final String sourceId;

    public CreateHtml5BatchRequest(Long clientId, String name, String sourceId) {
        this.clientId = clientId;
        this.name = name;
        this.sourceId = sourceId;

        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());

        Html5BatchRequest request = new Html5BatchRequest()
                .withName(name)
                .withSources(Collections.singletonList(new Html5SourceRequest().withId(sourceId)));
        String body = toJson(request);
        requestBuilder.setBody(body);
    }

    public Html5BatchResponse deserializeResponse(String resp) {
        return fromJson(resp, Html5BatchResponse.class);
    }

    public static final class Html5SourceRequest {
        @JsonProperty("id")
        private String id;

        public String getId() {
            return id;
        }

        public Html5SourceRequest withId(String id) {
            this.id = id;
            return this;
        }
    }

    public static final class Html5BatchRequest {
        @JsonProperty("name")
        private String name;

        @JsonProperty("sources")
        private List<Html5SourceRequest> sources;

        public String getName() {
            return name;
        }

        public Html5BatchRequest withName(String name) {
            this.name = name;
            return this;
        }

        public List<Html5SourceRequest> getSources() {
            return sources;
        }

        public Html5BatchRequest withSources(List<Html5SourceRequest> sources) {
            this.sources = sources;
            return this;
        }
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
