package ru.yandex.direct.canvas.client.model.html5;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;

public class Html5SourceResponse {
    @JsonProperty("id")
    private String id;

    @JsonProperty("screenshot_url")
    private String screenshotUrl;

    @JsonProperty("preview_url")
    private String previewUrl;

    @JsonProperty("url")
    private String url;

    @JsonProperty("width")
    private Integer width;

    @JsonProperty("height")
    private Integer height;

    private Integer originalWidth;

    private Integer originalHeight;

    @JsonProperty("source_image_info")
    private void unpackOriginalSizes(JsonNode sourceImageInfo) {
        var metadataInfo = sourceImageInfo.get("metadataInfo");
        if (metadataInfo != null) {
            if (metadataInfo.get("width") != null) {
                originalWidth = metadataInfo.get("width").asInt();
            }
            if (metadataInfo.get("height") != null) {
                originalHeight = metadataInfo.get("height").asInt();
            }
        }
    }

    public String getId() {
        return id;
    }

    public Html5SourceResponse withId(String id) {
        this.id = id;
        return this;
    }

    public String getScreenshotUrl() {
        return screenshotUrl;
    }

    public Html5SourceResponse withScreenshotUrl(String screenshotUrl) {
        this.screenshotUrl = screenshotUrl;
        return this;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public Html5SourceResponse withPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public Html5SourceResponse withUrl(String url) {
        this.url = url;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public Html5SourceResponse withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public Html5SourceResponse withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Integer getOriginalWidth() {
        return originalWidth;
    }

    public Html5SourceResponse withOriginalWidth(Integer originalWidth) {
        this.originalWidth = originalWidth;
        return this;
    }

    public Integer getOriginalHeight() {
        return originalHeight;
    }

    public Html5SourceResponse withOriginalHeight(Integer originalHeight) {
        this.originalHeight = originalHeight;
        return this;
    }
}
