package ru.yandex.direct.canvas.client.model.html5;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

public class UploadHtml5CreativeToDirectRequest extends CanvasRequest<List<Long>> {
    private static final String PATH = "html5/direct/internal-creatives";

    private final Long clientId;
    private final Long userId;
    private final String batchId;
    private final Long creativeId;

    public UploadHtml5CreativeToDirectRequest(Long clientId, Long userId, String batchId, Long creativeId) {
        this.clientId = clientId;
        this.userId = userId;
        this.batchId = batchId;
        this.creativeId = creativeId;

        setPath(PATH);
    }

        public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());
        requestBuilder.addQueryParam("user_id", userId.toString());

        BatchRequest batchRequest = new BatchRequest()
                .withId(batchId)
                .withCreativeIds(Collections.singletonList(creativeId));
        UploadRequest request = new UploadRequest()
                .withBatches(Collections.singletonList(batchRequest));
        String body = toJson(request);
        requestBuilder.setBody(body);
    }

    public List<Long> deserializeResponse(String resp) {
        return fromJson(resp, new TypeReference<>() {
        });
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }

    public static class UploadRequest {
        @JsonProperty("batches")
        private List<BatchRequest> batches;

        public List<BatchRequest> getBatches() {
            return batches;
        }

        public UploadRequest withBatches(List<BatchRequest> batches) {
            this.batches = batches;
            return this;
        }
    }

    public static class BatchRequest {
        @JsonProperty("id")
        private String id;

        @JsonProperty("creative_ids")
        private List<Long> creativeIds;

        public String getId() {
            return id;
        }

        public BatchRequest withId(String id) {
            this.id = id;
            return this;
        }

        public List<Long> getCreativeIds() {
            return creativeIds;
        }

        public BatchRequest withCreativeIds(List<Long> creativeIds) {
            this.creativeIds = creativeIds;
            return this;
        }
    }
}
