package ru.yandex.direct.canvas.client.model.html5;

import java.nio.charset.StandardCharsets;
import java.util.Locale;

import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_OCTET_STREAM;
import static io.netty.handler.codec.http.HttpHeaderValues.MULTIPART_FORM_DATA;
import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class UploadHtml5Request extends CanvasRequest<Html5SourceResponse> {
    private static final String PATH = "html5/internal-source";

    private final Long clientId;
    private final byte[] data;
    private final String name;
    private final Html5Tag html5Tag;

    public UploadHtml5Request(Long clientId, byte[] data, String name, Html5Tag html5Tag, Locale locale) {
        this.clientId = clientId;
        this.data = data;
        this.name = name;
        this.html5Tag = html5Tag;

        setLocale(locale);
        setContentType(MULTIPART_FORM_DATA.toString());
        setPath(PATH);
        }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());
        requestBuilder.addQueryParam("html5_tag", html5Tag.name());
        requestBuilder.addBodyPart(new ByteArrayPart(
                "attachment", data, APPLICATION_OCTET_STREAM.toString(), StandardCharsets.UTF_8, name));
    }

    public Html5SourceResponse deserializeResponse(String resp) {
        return fromJson(resp, Html5SourceResponse.class);
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
