package ru.yandex.direct.canvas.client.model.video;

import java.util.Date;
import java.util.Locale;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public class AdditionResponse {
    @JsonProperty("id")
    private String id;

    @JsonProperty("preset_id")
    private Long presetId;

    @JsonProperty("name")
    private String name;

    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("archive")
    private Boolean archive;

    @JsonProperty("status_rtb")
    private RtbStatus statusRtb;

    @JsonProperty("creation_time")
    private Date creationTime;

    @JsonProperty("date")
    private Date date;

    @JsonProperty("vast")
    private String vast;

    @JsonProperty("screenshot_url")
    private String screenshotUrl;

    @JsonProperty("screenshot_is_done")
    private Boolean screenshotIsDone;

    @JsonProperty("creative_id")
    private Long creativeId;

    @JsonProperty("stock_creative_id")
    private Long stockCreativeId;

    @JsonProperty("skip_url")
    private String skipUrl;

    @JsonProperty("vpaid_pcode_url")
    private String vpaidPcodeUrl;

    private String previewUrl;

    public String getId() {
        return id;
    }

    public AdditionResponse withId(String id) {
        this.id = id;
        return this;
    }

    public Long getPresetId() {
        return presetId;
    }

    public AdditionResponse withPresetId(Long presetId) {
        this.presetId = presetId;
        return this;
    }

    public String getName() {
        return name;
    }

    public AdditionResponse withName(String name) {
        this.name = name;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public AdditionResponse withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getArchive() {
        return archive;
    }

    public AdditionResponse withArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public Date getCreationTime() {
        return creationTime;
    }

    public AdditionResponse withCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public RtbStatus getStatusRtb() {
        return statusRtb;
    }

    public AdditionResponse withStatusRtb(RtbStatus statusRtb) {
        this.statusRtb = statusRtb;
        return this;
    }

    public Date getDate() {
        return date;
    }

    public AdditionResponse withDate(Date date) {
        this.date = date;
        return this;
    }

    public String getVast() {
        return vast;
    }

    public AdditionResponse withVast(String vast) {
        this.vast = vast;
        return this;
    }

    public String getScreenshotUrl() {
        return screenshotUrl;
    }

    public AdditionResponse withScreenshotUrl(String screenshotUrl) {
        this.screenshotUrl = screenshotUrl;
        return this;
    }

    public Boolean getScreenshotIsDone() {
        return screenshotIsDone;
    }

    public AdditionResponse withScreenshotIsDone(Boolean screenshotIsDone) {
        this.screenshotIsDone = screenshotIsDone;
        return this;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public AdditionResponse withCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public Long getStockCreativeId() {
        return stockCreativeId;
    }

    public AdditionResponse withStockCreativeId(Long stockCreativeId) {
        this.stockCreativeId = stockCreativeId;
        return this;
    }

    public String getSkipUrl() {
        return skipUrl;
    }

    public AdditionResponse withSkipUrl(String skipUrl) {
        this.skipUrl = skipUrl;
        return this;
    }

    public String getVpaidPcodeUrl() {
        return vpaidPcodeUrl;
    }

    public AdditionResponse withVpaidPcodeUrl(String vpaidPcodeUrl) {
        this.vpaidPcodeUrl = vpaidPcodeUrl;
        return this;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public AdditionResponse withPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }


    public enum RtbStatus {
        SENT,
        NEW;

        @JsonValue
        public String getValue() {
            return name().toLowerCase();
        }

        @JsonCreator
        public static RtbStatus fromString(String name) {
            return RtbStatus.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }
}
