package ru.yandex.direct.canvas.client.model.video;

import java.nio.charset.StandardCharsets;
import java.util.Locale;

import javax.annotation.Nullable;

import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.request.body.multipart.ByteArrayPart;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static io.netty.handler.codec.http.HttpHeaderValues.APPLICATION_OCTET_STREAM;
import static io.netty.handler.codec.http.HttpHeaderValues.MULTIPART_FORM_DATA;
import static ru.yandex.direct.utils.JsonUtils.fromJson;


public class CreateVideoFromFileRequest extends CanvasRequest<VideoUploadResponse> {
    private static final String PATH = "video/default/create-video-from-file";

    private Long clientId;
    private byte[] data;
    private String name;
    private UacVideoCreativeType uacVideoCreativeType;

    public CreateVideoFromFileRequest(
            Long clientId, byte[] data, String name, @Nullable UacVideoCreativeType uacVideoCreativeType, @Nullable Locale locale
    ) {
        this.clientId = clientId;
        this.data = data;
        this.name = name;
        this.uacVideoCreativeType = uacVideoCreativeType;

        setLocale(locale);
        setContentType(MULTIPART_FORM_DATA.toString());
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());
        if (uacVideoCreativeType != null) {
            requestBuilder.addQueryParam("creativeType", uacVideoCreativeType.getLiteral());
        }
        requestBuilder.addBodyPart(new ByteArrayPart(
                "file", data, APPLICATION_OCTET_STREAM.toString(), StandardCharsets.UTF_8, name));
    }

    public VideoUploadResponse deserializeResponse(String resp) {
        return fromJson(resp, VideoUploadResponse.class);
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
