package ru.yandex.direct.canvas.client.model.video;

import java.util.Locale;

import javax.annotation.Nullable;

import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

public class CreateVideoFromUrlRequest extends CanvasRequest<VideoUploadResponse> {
    private static final String PATH = "video/default/create-video";

    private Long clientId;
    private String url;
    private UacVideoCreativeType uacVideoCreativeType;

    public CreateVideoFromUrlRequest(Long clientId, String url, @Nullable UacVideoCreativeType uacVideoCreativeType, @Nullable Locale locale) {
        this.clientId = clientId;
        this.url = url;
        this.uacVideoCreativeType = uacVideoCreativeType;

        setLocale(locale);
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());
        if (uacVideoCreativeType != null) {
            requestBuilder.addQueryParam("creativeType", uacVideoCreativeType.getLiteral());
        }

        UploadUrlRequest request = new UploadUrlRequest()
                .withUrl(url);
        String body = toJson(request);
        requestBuilder.setBody(body);
    }

    public VideoUploadResponse deserializeResponse(String resp) {
        return fromJson(resp, VideoUploadResponse.class);
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
