package ru.yandex.direct.canvas.client.model.video;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Creative {
    private static final Logger logger = LoggerFactory.getLogger(Creative.class);

    @JsonProperty("creative_name")
    private String creativeName;
    @JsonProperty("stock_creative_id")
    private Long stockCreativeId;
    @JsonProperty("creative_type")
    private CreativeType creativeType;
    @JsonProperty("moderation_info")
    private ModerateInfo moderationInfo;
    @JsonProperty("preview_url")
    private String previewUrl;
    @JsonProperty("creative_id")
    private Long creativeId;
    @JsonProperty("live_preview_url")
    private String livePreviewUrl;
    @JsonProperty("width")
    private Integer width;
    @JsonProperty("height")
    private Integer height;
    @JsonProperty("duration")
    private Integer duration;
    @JsonProperty("preset_id")
    private Integer presetId;
    @JsonProperty("is_adaptive")
    private Boolean isAdaptive;
    @JsonProperty("has_packshot")
    private Boolean hasPackshot;
    @JsonProperty("is_brand_lift")
    private Boolean isBrandLift;

    public String getCreativeName() {
        return creativeName;
    }

    public void setCreativeName(String creativeName) {
        this.creativeName = creativeName;
    }

    public Long getStockCreativeId() {
        return stockCreativeId;
    }

    public void setStockCreativeId(Long stockCreativeId) {
        this.stockCreativeId = stockCreativeId;
    }

    public CreativeType getCreativeType() {
        return creativeType;
    }

    public void setCreativeType(CreativeType creativeType) {
        this.creativeType = creativeType;
    }

    public ModerateInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(ModerateInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
    }

    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public void setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getPresetId() {
        return presetId;
    }

    public void setPresetId(Integer presetId) {
        this.presetId = presetId;
    }

    public Boolean getIsAdaptive() {
        return isAdaptive;
    }

    public void setIsAdaptive(Boolean isAdaptive) {
        this.isAdaptive = isAdaptive;
    }

    public Boolean getHasPackshot() {
        return hasPackshot;
    }

    public void setHasPackshot(Boolean hasPackshot) {
        this.hasPackshot = hasPackshot;
    }

    public Boolean getIsBrandLift() {
        return isBrandLift;
    }

    public void setIsBrandLift(Boolean brandLift) {
        isBrandLift = brandLift;
    }

    public Creative withCreativeName(String creativeName) {
        this.creativeName = creativeName;
        return this;
    }

    public Creative withStockCreativeId(Long stockCreativeId) {
        this.stockCreativeId = stockCreativeId;
        return this;
    }

    public Creative withCreativeType(
            CreativeType creativeType) {
        this.creativeType = creativeType;
        return this;
    }

    public Creative withModerationInfo(
            ModerateInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
        return this;
    }

    public Creative withPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return this;
    }

    public Creative withCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    public Creative withLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
        return this;
    }

    public Creative withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Creative withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Creative withDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public Creative withPresetId(Integer presetId) {
        this.presetId = presetId;
        return this;
    }

    public Creative withIsAdaptive(Boolean isAdaptive) {
        this.isAdaptive = isAdaptive;
        return this;
    }

    public Creative withHasPackshot(Boolean hasPackshot) {
        this.hasPackshot = hasPackshot;
        return this;
    }

    public Creative withIsBrandLift(Boolean brandLift) {
        isBrandLift = brandLift;
        return this;
    }

    public enum CreativeType {
        PERFORMANCE("perfomance"),

        CANVAS("canvas"),

        VIDEO_ADDITION("videoAddition"),

        HTML5_CREATIVE("html5Creative");

        private final String value;
        private static final ImmutableMap<String, CreativeType> ENUM_MAP;


        CreativeType(String type) {
            value = type;
        }

        public String getValue() {
            return value;
        }

        @JsonCreator
        @Nullable
        public static CreativeType fromString(String value) {
            CreativeType result = ENUM_MAP.get(value);
            if (result != null) {
                return result;
            }
            if (value == null) {
                logger.warn("Value is null");
            }
            logger.warn("invalid creative_type: " + value);
            return null;
        }

        static {
            Map<String, CreativeType> map = new ConcurrentHashMap<>();
            for (CreativeType instance : CreativeType.values()) {
                map.put(instance.getValue(), instance);
            }
            ENUM_MAP = ImmutableMap.copyOf(map);
        }
    }
}
