package ru.yandex.direct.canvas.client.model.video;
import java.util.List;
/**
 * Answer of /DirectCanvas/upload_creatives.
 *
 * @author pupssman
 * @see <a href=https://wiki.yandex-team.ru/Direkt/TechnicalDesign/creative-canvas/#vzaimodejjstviekkonstruktoromcherezintapi>https://wiki.yandex-team.ru/Direkt/TechnicalDesign/creative-canvas/#vzaimodejjstviekkonstruktoromcherezintapi</a>
 */
public class DirectUploadResult {
    private List<DirectUploadCreativeResult> uploadResults;
    public List<DirectUploadCreativeResult> getUploadResults() {
        return uploadResults;
    }
    public void setUploadResults(List<DirectUploadCreativeResult> uploadResults) {
        this.uploadResults = uploadResults;
    }
    public boolean isOk() {
        return uploadResults.stream().allMatch(DirectUploadCreativeResult::isOk);
    }
    @Override
    public String toString() {
        return String.format("DirectUploadResult [uploadResults=%s]", uploadResults);
    }
    /**
     * Answer for single creative
     */
    public static class DirectUploadCreativeResult {
        private Long creativeId;
        private String status;
        private String message;
        public Long getCreativeId() {
            return creativeId;
        }
        public void setCreativeId(Long creativeId) {
            this.creativeId = creativeId;
        }
        public String getStatus() {
            return status;
        }
        public void setStatus(String status) {
            this.status = status;
        }
        public String getMessage() {
            return message;
        }
        public void setMessage(String message) {
            this.message = message;
        }
        public boolean isOk() {
            return Status.OK.name().equals(getStatus());
        }
        @Override
        public String toString() {
            return String
                    .format("DirectUploadCreativeResult [creativeId=%s, status=%s, message=%s]", creativeId, status,
                            message);
        }
        /**
         * Expected statuses.
         */
        public static enum Status {
            OK,
            ERROR
        }
    }
}
