package ru.yandex.direct.canvas.client.model.video;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class GenerateConditions {
    @JsonProperty("category_ids")
    private List<String> categories;

    @JsonProperty("count")
    private Integer count;

    @JsonProperty("locale")
    private String locale;

    @JsonProperty("creative_type")
    private String creativeType;

    @JsonProperty("banner_type")
    private String bannerType;

    public List<String> getCategories() {
        return categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public GenerateConditions withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public GenerateConditions withCount(Integer count) {
        this.count = count;
        return this;
    }

    public String getLocale() {
        return locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public GenerateConditions withLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public String getCreativeType() {
        return creativeType;
    }

    public void setCreativeType(String creativeType) {
        this.creativeType = creativeType;
    }

    public GenerateConditions withCreativeType(String creativeType) {
        this.creativeType = creativeType;
        return this;
    }

    public String getBannerType() {
        return bannerType;
    }

    public void setBannerType(String bannerType) {
        this.bannerType = bannerType;
    }

    public GenerateConditions withBannerType(String bannerType) {
        this.bannerType = bannerType;
        return this;
    }

    public enum VideoAdditionLocale {
        EN_US("en_US"),
        RU_RU("ru_RU"),
        TR_TR("tr_TR"),
        UK_UA("uk_UA");

        private String locale;

        VideoAdditionLocale(String locale) {
            this.locale = locale;
        }

        public String getLocale() {
            return locale;
        }
    }

}
