package ru.yandex.direct.canvas.client.model.video;

import java.util.List;

import com.fasterxml.jackson.core.type.TypeReference;
import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;
import static ru.yandex.direct.utils.JsonUtils.toJson;

public class GenerateVideoAdditions extends CanvasRequest<List<List<Creative>>> {
    private static final String PATH = "generate-creatives";
    private Long clientId;
    private List<GenerateConditions> conditions;

    public GenerateVideoAdditions(Long clientId, List<GenerateConditions> conditions) {
        this.clientId = clientId;
        this.conditions = conditions;
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        GenerateCreativesRequest request = new GenerateCreativesRequest()
                .withClientId(clientId)
                .withConditions(conditions);
        String body = toJson(request);
        requestBuilder.setBody(body);
    }

    public List<List<Creative>> deserializeResponse(String resp) {
        return fromJson(resp, new TypeReference<>() {
        });
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
