package ru.yandex.direct.canvas.client.model.video;

import javax.annotation.Nullable;

import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class GetCreatedVideoRequest extends CanvasRequest<VideoUploadResponse> {
    private static final String PATH = "video/default/get-created-video";

    private Long clientId;
    private Long presetId;
    private String videoId;
    private UacVideoCreativeType uacVideoCreativeType;

    public GetCreatedVideoRequest(
            Long clientId, Long presetId, String videoId,
            @Nullable UacVideoCreativeType uacVideoCreativeType) {
        this.clientId = clientId;
        this.presetId = presetId;
        this.videoId = videoId;
        this.uacVideoCreativeType = uacVideoCreativeType;
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());
        requestBuilder.addQueryParam("preset_id", presetId.toString());
        requestBuilder.addQueryParam("video_id", videoId);
        if (uacVideoCreativeType != null) {
            requestBuilder.addQueryParam("creativeType", uacVideoCreativeType.getLiteral());
        }
    }

    public VideoUploadResponse deserializeResponse(String resp) {
        return fromJson(resp, VideoUploadResponse.class);
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
