package ru.yandex.direct.canvas.client.model.video;

import java.util.List;

import one.util.streamex.StreamEx;
import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class GetUcVideoAdditionsRequest extends CanvasRequest<List<UcCreativeResponse>> {
    private static final String PATH = "ucCreativesData";

    private Long clientId;
    private List<Long> creativeIds;

    public GetUcVideoAdditionsRequest(Long clientId, List<Long> creativeIds) {
        this.clientId = clientId;
        this.creativeIds = creativeIds;
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", this.clientId.toString());
        requestBuilder.addQueryParam("ids", StreamEx.of(this.creativeIds).joining(","));
    }

    public List<UcCreativeResponse> deserializeResponse(String resp) {
        return StreamEx.of(fromJson(resp, UcCreativeResponse[].class))
                .filter(UcCreativeResponse::getOk)
                .toList();
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
