package ru.yandex.direct.canvas.client.model.video;

import java.util.List;

import one.util.streamex.StreamEx;
import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class GetVideoAdditionsRequest extends CanvasRequest<List<CreativeResponse>> {
    private static final String PATH = "creatives";

    private Long clientId;
    private List<Long> creativeIds;

    public GetVideoAdditionsRequest(Long clientId, List<Long> creativeIds) {
        this.clientId = clientId;
        this.creativeIds = creativeIds;
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", this.clientId.toString());
        requestBuilder.addQueryParam("ids", StreamEx.of(this.creativeIds).joining(","));
    }

    public List<CreativeResponse> deserializeResponse(String resp) {
        return StreamEx.of(fromJson(resp, CreativeResponse[].class))
                .filter(CreativeResponse::getOk)
                .filter(creativeResponse -> creativeResponse.getCreative().getCreativeType() != null)
                .toList();
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
