package ru.yandex.direct.canvas.client.model.video;

import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class GetVideoByIdRequest extends CanvasRequest<VideoUploadResponse> {
    private static final String PATH = "video/files/internal/";

    private final Long clientId;

    public GetVideoByIdRequest(Long clientId, String videoId) {
        this.clientId = clientId;

        setPath(PATH + videoId);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());
    }

    public VideoUploadResponse deserializeResponse(String resp) {
        return fromJson(resp, VideoUploadResponse.class);
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }

}
