package ru.yandex.direct.canvas.client.model.video;

import org.asynchttpclient.RequestBuilder;

import ru.yandex.direct.canvas.client.model.CanvasRequest;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class GetVideoRequest extends CanvasRequest<VideoResponse> {
    private static final String PATH = "video/default/get-video";

    private Long clientId;
    private Long presetId;
    private String videoId;

    public GetVideoRequest(Long clientId, Long presetId, String videoId) {
        this.clientId = clientId;
        this.presetId = presetId;
        this.videoId = videoId;
        setPath(PATH);
    }

    public void prepareRequest(RequestBuilder requestBuilder) {
        requestBuilder.addQueryParam("client_id", clientId.toString());
        requestBuilder.addQueryParam("preset_id", presetId.toString());
        requestBuilder.addQueryParam("video_id", videoId);
    }

    public VideoResponse deserializeResponse(String resp) {
        return fromJson(resp, VideoResponse.class);
    }

    @Override
    public String getMetricsPath() {
        return PATH;
    }
}
