package ru.yandex.direct.canvas.client.model.video;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ModerateInfo {
    @JsonProperty("html")
    private ModerationInfoHtml html;

    @JsonProperty("images")
    private List<ModerationInfoImage> images;

    @JsonProperty("texts")
    private List<ModerationInfoText> texts;

    @JsonProperty("videos")
    private List<ModerationInfoVideo> videos;

    @JsonProperty("sounds")
    private List<ModerationInfoSound> sounds;

    @JsonProperty("aspects")
    private List<ModerationInfoAspect> aspects;

    public ModerationInfoHtml getHtml() {
        return html;
    }

    public void setHtml(ModerationInfoHtml html) {
        this.html = html;
    }

    public List<ModerationInfoImage> getImages() {
        return images;
    }

    public void setImages(
            List<ModerationInfoImage> images) {
        this.images = images;
    }

    public List<ModerationInfoText> getTexts() {
        return texts;
    }

    public void setTexts(
            List<ModerationInfoText> texts) {
        this.texts = texts;
    }

    public List<ModerationInfoVideo> getVideos() {
        return videos;
    }

    public void setVideos(
            List<ModerationInfoVideo> videos) {
        this.videos = videos;
    }

    public List<ModerationInfoSound> getSounds() {
        return sounds;
    }

    public void setSounds(
            List<ModerationInfoSound> sounds) {
        this.sounds = sounds;
    }

    public List<ModerationInfoAspect> getAspects() {
        return aspects;
    }

    public void setAspects(
            List<ModerationInfoAspect> aspects) {
        this.aspects = aspects;
    }

    public ModerateInfo withHtml(
            ModerationInfoHtml html) {
        this.html = html;
        return this;
    }

    public ModerateInfo withImages(
            List<ModerationInfoImage> images) {
        this.images = images;
        return this;
    }

    public ModerateInfo withTexts(
            List<ModerationInfoText> texts) {
        this.texts = texts;
        return this;
    }

    public ModerateInfo withVideos(
            List<ModerationInfoVideo> videos) {
        this.videos = videos;
        return this;
    }

    public ModerateInfo withSounds(
            List<ModerationInfoSound> sounds) {
        this.sounds = sounds;
        return this;
    }

    public ModerateInfo withAspects(
            List<ModerationInfoAspect> aspects) {
        this.aspects = aspects;
        return this;
    }
}
