package ru.yandex.direct.canvas.client.model.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preset {
    private static final Logger logger = LoggerFactory.getLogger(Preset.class);
    @JsonProperty("name")
    private String presetName;
    @JsonProperty("id")
    private Long presetId;
    @JsonProperty("isAdaptive")
    private Boolean isAdaptive;

    public String getPresetName() {
        return presetName;
    }

    public void setPresetName(String presetName) {
        this.presetName = presetName;
    }

    public Long getPresetId() {
        return presetId;
    }

    public void setPresetId(Long presetId) {
        this.presetId = presetId;
    }

    public Preset withPresetName(String presetName) {
        this.presetName = presetName;
        return this;
    }

    public Preset withPresetId(Long presetId) {
        this.presetId = presetId;
        return this;
    }

    public Boolean getIsAdaptive() {
        return isAdaptive;
    }

    public Preset withIsAdaptive(Boolean isAdaptive) {
        this.isAdaptive = isAdaptive;
        return this;
    }
}
