package ru.yandex.direct.canvas.client.model.video;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class PresetResponse {
    @JsonProperty("videoPresets")
    private List<Preset> videoPresets;
    @JsonProperty("canvasPresets")
    private List<Preset> canvasPresets;

    @JsonProperty("html5Presets")
    private List<Preset> html5Presets;

    public List<Preset> getHtml5Presets() {
        return html5Presets;
    }

    public void setHtml5Presets(List<Preset> html5Presets) {
        this.html5Presets = html5Presets;
    }

    public List<Preset> getVideoPresets() {
        return videoPresets;
    }

    public void setVideoPresets(List<Preset> videoPresets) {
        this.videoPresets = videoPresets;
    }

    public List<Preset> getCanvasPresets() {
        return canvasPresets;
    }

    public void setCanvasPresets(List<Preset> canvasPresets) {
        this.canvasPresets = canvasPresets;
    }

    public PresetResponse withVideoPresets(List<Preset> videoPresets) {
        this.videoPresets = videoPresets;
        return this;
    }

    public PresetResponse withCanvasPresets(List<Preset> canvasPresets) {
        this.canvasPresets = canvasPresets;
        return this;
    }

    public PresetResponse withHtml5Presets(List<Preset> html5Presets) {
        this.html5Presets = html5Presets;
        return this;
    }

}
