package ru.yandex.direct.canvas.client.model.video;

import com.fasterxml.jackson.annotation.JsonProperty;

public class VideoFormat {
    @JsonProperty("type")
    private String type;

    @JsonProperty("url")
    private String url;

    @JsonProperty("delivery")
    private String delivery;

    @JsonProperty("bitrate")
    private Long bitrate;

    public String getType() {
        return type;
    }

    public VideoFormat withType(String type) {
        this.type = type;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public VideoFormat withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getDelivery() {
        return delivery;
    }

    public VideoFormat withDelivery(String delivery) {
        this.delivery = delivery;
        return this;
    }

    public Long getBitrate() {
        return bitrate;
    }

    public VideoFormat withBitrate(Long bitrate) {
        this.bitrate = bitrate;
        return this;
    }
}
