package ru.yandex.direct.canvas.client.model.video;

import com.fasterxml.jackson.annotation.JsonProperty;

public class VideoThumbnail {
    @JsonProperty("url")
    private String url;

    @JsonProperty("width")
    private Long width;

    @JsonProperty("height")
    private Long height;

    @JsonProperty("preview")
    private VideoThumbnailPreview preview;

    public String getUrl() {
        return url;
    }

    public VideoThumbnail withUrl(String url) {
        this.url = url;
        return this;
    }

    public Long getWidth() {
        return width;
    }

    public VideoThumbnail withWidth(Long width) {
        this.width = width;
        return this;
    }

    public Long getHeight() {
        return height;
    }

    public VideoThumbnail withHeigth(Long height) {
        this.height = height;
        return this;
    }

    public VideoThumbnailPreview getPreview() {
        return preview;
    }

    public VideoThumbnail withPreview(VideoThumbnailPreview preview) {
        this.preview = preview;
        return this;
    }
}
