package ru.yandex.direct.canvas.client.model.video;

import java.util.List;
import java.util.Locale;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

public class VideoUploadResponse {
    @JsonProperty("preset_id")
    private Long presetId;

    @JsonProperty("id")
    private String id;

    @JsonProperty("name")
    private String name;

    @JsonProperty("status")
    private FileStatus status;

    @JsonProperty("show_early_preview")
    private Boolean showEarlyPreview;

    @JsonProperty("create_early_creative")
    private Boolean createEarlyCreative;

    @JsonProperty("stock_file_id")
    private String stockFileId;

    @JsonProperty("conversion_task_id")
    private Long conversionTaskId;

    @JsonProperty("stillage_id")
    private String stillageId;

    @JsonProperty("type")
    private String type;

    @JsonProperty("client_id")
    private Long clientId;

    @JsonProperty("url")
    private String url;

    @JsonProperty("error_message")
    private String errorMessage;

    @JsonProperty("width")
    private Integer width;

    @JsonProperty("height")
    private Integer height;

    @JsonProperty("duration")
    private Double duration;

    @JsonProperty("thumbnail")
    private VideoThumbnail thumbnail;

    @JsonProperty("thumbnailUrl")
    private String thumbnailUrl;

    @JsonProperty("formats")
    private List<VideoFormat> formats;

    @JsonProperty("mime_type")
    private String mimeType;

    public String getId() {
        return id;
    }

    public VideoUploadResponse withId(String id) {
        this.id = id;
        return this;
    }

    public Long getPresetId() {
        return presetId;
    }

    public VideoUploadResponse withPresetId(Long presetId) {
        this.presetId = presetId;
        return this;
    }

    public String getName() {
        return name;
    }

    public VideoUploadResponse withName(String name) {
        this.name = name;
        return this;
    }

    public FileStatus getStatus() {
        return status;
    }

    public VideoUploadResponse withStatus(FileStatus status) {
        this.status = status;
        return this;
    }

    public Boolean getShowEarlyPreview() {
        return showEarlyPreview;
    }

    public VideoUploadResponse withShowEarlyPreview(Boolean showEarlyPreview) {
        this.showEarlyPreview = showEarlyPreview;
        return this;
    }

    public Boolean getCreateEarlyCreative() {
        return createEarlyCreative;
    }

    public VideoUploadResponse withCreateEarlyCreative(Boolean createEarlyCreative) {
        this.createEarlyCreative = createEarlyCreative;
        return this;
    }

    public String getStockFileId() {
        return stockFileId;
    }

    public VideoUploadResponse withStockFileId(String stockFileId) {
        this.stockFileId = stockFileId;
        return this;
    }

    public Long getConversionTaskId() {
        return conversionTaskId;
    }

    public VideoUploadResponse withConversionTaskId(Long conversionTaskId) {
        this.conversionTaskId = conversionTaskId;
        return this;
    }

    public String getStillageId() {
        return stillageId;
    }

    public VideoUploadResponse withStillageId(String stillageId) {
        this.stillageId = stillageId;
        return this;
    }

    public String getType() {
        return type;
    }

    public VideoUploadResponse withType(String type) {
        this.type = type;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public VideoUploadResponse withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public VideoUploadResponse withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public VideoUploadResponse withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public Integer getWidth() {
        return width;
    }

    public VideoUploadResponse withWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return height;
    }

    public VideoUploadResponse withHeight(Integer height) {
        this.height = height;
        return this;
    }

    public Double getDuration() {
        return duration;
    }

    public VideoUploadResponse withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    public VideoThumbnail getThumbnail() {
        return thumbnail;
    }

    public VideoUploadResponse withThumbnail(VideoThumbnail thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public VideoUploadResponse withThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        return this;
    }

    public List<VideoFormat> getFormats() {
        return formats;
    }

    public VideoUploadResponse withFormats(List<VideoFormat> formats) {
        this.formats = formats;
        return this;
    }

    public String getMimeType() {
        return mimeType;
    }

    public VideoUploadResponse withMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public enum FileStatus {
        READY,
        SEMI_READY,
        ERROR,
        CONVERTING,
        NEW;

        @JsonValue
        public String getValue() {
            return name().toLowerCase();
        }

        @JsonCreator
        public static FileStatus fromString(String name) {
            return FileStatus.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }
}
