package ru.yandex.direct.clemmer;

import java.util.List;
import java.util.Objects;

import ru.yandex.direct.tracing.Trace;
import ru.yandex.direct.tracing.TraceProfile;

public class Clemmer {
    static {
        System.loadLibrary("direct-clemmer-jni");
    }

    private Clemmer() {
        // static class
    }

    public static List<ClemmerWord> analyze2(String phrase) {
        return analyze2(phrase, ClemmerLanguage.UNKNOWN);
    }

    public static List<ClemmerWord> analyze2(String phrase, boolean fillFormas) {
        return analyze2(phrase, ClemmerLanguage.UNKNOWN, fillFormas);
    }

    public static List<ClemmerWord> analyze2(String phrase, ClemmerLanguage language) {
        return analyze2(phrase, language, true);
    }

    public static List<ClemmerWord> analyze2(String phrase, ClemmerLanguage language, boolean fillFormas) {
        try (TraceProfile profile = Trace.current().profile("clemmer:analyze2")) {
            return analyze2(Objects.requireNonNull(phrase), language.getValue(), fillFormas);
        }
    }

    private static native List<ClemmerWord> analyze2(String phrase, int lang, boolean fillFormas);
}
