package ru.yandex.direct.clemmer;

import java.util.List;
import java.util.Objects;

public class ClemmerWord {
    private final String text;
    private final List<String> lemmas;
    private final List<String> formas;
    private final int flags;
    private final int rawFlags;

    public ClemmerWord(String text, List<String> lemmas, List<String> formas, int flags, int rawFlags) {
        this.text = Objects.requireNonNull(text);
        this.lemmas = Objects.requireNonNull(lemmas);
        this.formas = Objects.requireNonNull(formas);
        this.flags = flags;
        this.rawFlags = rawFlags;
    }

    public String getText() {
        return text;
    }

    public List<String> getLemmas() {
        return lemmas;
    }

    public List<String> getFormas() {
        return formas;
    }

    public int getFlags() {
        return flags;
    }

    public int getRawFlags() {
        return rawFlags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ClemmerWord that = (ClemmerWord) o;

        if (flags != that.flags) {
            return false;
        }
        if (rawFlags != that.rawFlags) {
            return false;
        }
        if (!text.equals(that.text)) {
            return false;
        }
        if (!lemmas.equals(that.lemmas)) {
            return false;
        }
        return formas.equals(that.formas);
    }

    @Override
    public int hashCode() {
        int result = text.hashCode();
        result = 31 * result + lemmas.hashCode();
        result = 31 * result + formas.hashCode();
        result = 31 * result + flags;
        result = 31 * result + rawFlags;
        return result;
    }

    @Override
    public String toString() {
        return "ClemmerWord{" +
                "text='" + text + '\'' +
                ", lemmas=" + lemmas +
                ", formas=" + formas +
                ", flags=" + flags +
                ", rawFlags=" + rawFlags +
                '}';
    }
}
