package ru.yandex.direct.clickhouse;

import java.sql.Connection;
import java.util.Arrays;

public class ClickHouseTable {
    private Connection conn;
    private String dbName;
    private String tableName;

    public ClickHouseTable(Connection conn, String dbName, String tableName) {
        this.conn = conn;
        this.dbName = dbName;
        this.tableName = tableName;
    }

    public Connection getConn() {
        return conn;
    }

    public String getDbName() {
        return dbName;
    }

    public String getTableName() {
        return tableName;
    }

    public String getQuotedFullTableName() {
        return ClickHouseUtils.quoteName(dbName) + "." + ClickHouseUtils.quoteName(tableName);
    }

    public InsertStatement createInsertStatement(ClickHouseInsertable<?>... fields) {
        return new InsertStatement(this, Arrays.asList(fields));
    }
}
