package ru.yandex.direct.clickhouse;

import java.sql.ResultSet;

public class FullyQualifiedField<T> implements ClickHouseInsertable<T> {
    private final ClickHouseTable table;
    private final ClickHouseInsertable<T> field;

    public FullyQualifiedField(ClickHouseTable table, ClickHouseInsertable<T> field) {
        this.table = table;
        this.field = field;
    }

    public static <T> ClickHouseSelectable<T> from(ClickHouseTable table, ClickHouseSelectable<T> field) {
        if (field instanceof FullyQualifiedField) {
            return field;
        } else if (field instanceof ClickHouseInsertable) {
            return new FullyQualifiedField<>(table, (ClickHouseInsertable<T>) field);
        }
        return field;
    }

    @Override
    public String getExpr() {
        return table.getQuotedFullTableName() + '.' + field.getExpr();
    }

    @Override
    public ClickHouseType<T> getType() {
        return field.getType();
    }

    @Override
    public T from(ResultSet resultSet) {
        throw new UnsupportedOperationException();
    }
}
