package ru.yandex.direct.clickhouse;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import ru.yandex.clickhouse.ClickHouseArray;
import ru.yandex.direct.utils.JsonUtils;

public class ResponseFieldNameAcessor {
    private Map<String, Integer> fields;
    private List<List<String>> data;

    public ResponseFieldNameAcessor(ResultSet resultSet) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            final int columnCount = metaData.getColumnCount();
            this.fields = new HashMap<>();
            for (int i = 0; i < columnCount; ++i) {
                this.fields.put(metaData.getColumnName(i + 1), i);
            }
            this.data = new ArrayList<>();
            while (resultSet.next()) {
                List<String> row = new ArrayList<>();
                for (int i = 1; i <= columnCount; ++i) {
                    var value = resultSet.getObject(i);
                    if (value instanceof ClickHouseArray) {
                        row.add(JsonUtils.toJson(((ClickHouseArray) value).getArray()));
                    } else {
                        row.add(value.toString());
                    }
                }
                this.data.add(row);
            }
        } catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public Stream<RowFieldNameAcessor> getData() {
        return data.stream().map(row -> new RowFieldNameAcessor(fields, row));
    }
}
