package ru.yandex.direct.clickhouse;

import java.sql.ResultSet;

import ru.yandex.direct.utils.Checked;

public class SimpleField<T> implements ClickHouseField, ClickHouseInsertable<T> {
    private final String name;
    private final ClickHouseType<T> type;

    public SimpleField(String name, ClickHouseType<T> type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return name;
    }

    @Override
    public ClickHouseType<T> getType() {
        return type;
    }

    @Override
    public T from(ResultSet resultSet) {
        return type.fromJavaSqlResult(Checked.get(() -> resultSet.getObject(name)));
    }

    @Override
    public String getExpr() {
        return ClickHouseUtils.quoteName(name);
    }

    @Override
    public String toSchemaString() {
        return name + ' ' + type.getTypeExpr();
    }

    @Override
    public String toString() {
        return "SimpleField{name='" + name + "', type='" + type.getTypeExpr() + "'}";
    }
}
