package ru.yandex.direct.clickhouse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlUnionBuilder extends SqlBuilder {

    private List<SqlBuilder> unionQueries = new ArrayList<>();

    private boolean isUnionAll;

    public SqlUnionBuilder(List<SqlBuilder> unionQueries, boolean isUnionAll) {
        this.unionQueries = unionQueries;
        this.isUnionAll = isUnionAll;
    }

    public SqlUnionBuilder union(SqlBuilder... queries){
        unionQueries.addAll(Arrays.asList(queries));
        return this;
    }

    @Override
    public String generateSql(boolean pretty) {
        String del = pretty ? "\n" : " ";

        var queries = unionQueries.stream()
                .map(s -> s.generateSql(pretty))
                .collect(Collectors.toList());

        return String.join(del + (isUnionAll ? "UNION ALL" : "UNION") + del, queries);
    }

    @Override
    public Object[] getBindings() {
        return unionQueries.stream()
                .map(SqlBuilder::getBindings)
                .flatMap(Stream::of)
                .toArray();
    }
}
