package ru.yandex.direct.clickhouse.types;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.core.type.TypeReference;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;
import ru.yandex.direct.utils.JsonUtils;

public class ArrayClickHouseType<T> extends ClickHouseType<List<T>> {
    private final TypeReference<List<T>> typeReference;
    private final ClickHouseType<T> itemType;

    public ArrayClickHouseType(ClickHouseType<T> itemType, TypeReference<List<T>> typeReference) {
        super("Array(" + itemType.getTypeExpr() + ")");
        this.typeReference = typeReference;
        this.itemType = itemType;
    }

    @Override
    public List<T> fromClickHouseString(String stringValue) {
        return JsonUtils.fromJson(stringValue, typeReference);
    }

    @Override
    public List<T> fromJavaSqlResult(Object value) {
        Object[] realValue = (Object[]) value;
        List<T> result = new ArrayList<T>(realValue.length);
        for (Object elem : realValue) {
            result.add(itemType.fromJavaSqlResult(elem));
        }
        return result;
    }

    @Override
    public void setNextInRecord(InsertRecord record, List<T> value) {
        record.setNext(value);
    }

    @Override
    public Object toSqlObject(List<T> value) {
        return value.stream().map(itemType::toSqlObject).collect(Collectors.toList());
    }
}
