package ru.yandex.direct.clickhouse.types;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

public class BooleanClickHouseType extends ClickHouseType<Boolean> {
    // Используется Enum8 вместо Int8, потому что clickhouse-jdbc-0.1.11 не умеет работать с массивами интов.
    // При этом в 0.1.17 ClickHouseStatement умеет сериализовывать и десериализовывать массивы интов и строк.
    public BooleanClickHouseType() {
        super("Enum8('true'=1, 'false'=0)");
    }

    @Override
    public Boolean fromClickHouseString(String stringValue) {
        switch (stringValue) {
            case "true":
                return true;
            case "false":
                return false;
            default:
                throw new IllegalArgumentException("Expected 'true' or 'false', got: " + stringValue);
        }
    }

    @Override
    public Boolean fromJavaSqlResult(Object value) {
        return fromClickHouseString((String) value);
    }

    @Override
    public void setNextInRecord(InsertRecord record, Boolean value) {
        record.setNext((String) toSqlObject(value));
    }

    @Override
    public Object toSqlObject(Boolean value) {
        return value ? "true" : "false";
    }
}
