package ru.yandex.direct.clickhouse.types;

import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneOffset;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

public class DateClickHouseType extends ClickHouseType<LocalDate> {
    public DateClickHouseType() {
        super("Date");
    }

    @Override
    public LocalDate fromClickHouseString(String stringValue) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public LocalDate fromJavaSqlResult(Object value) {
        return ((Date) value).toLocalDate();
    }

    @Override
    public void setNextInRecord(InsertRecord record, LocalDate value) {
        record.setNext(value);
    }

    @Override
    public Object toSqlObject(LocalDate value) {
        // java.sql.Date.from(Instant) возвращает java.util.Date. Приходится велосипедить.
        java.sql.Date result = new java.sql.Date(0);
        result.setTime(value.atStartOfDay().toEpochSecond(ZoneOffset.UTC) * 1000);
        return result;
    }
}
