package ru.yandex.direct.clickhouse.types;

import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.ClickHouseUtils;
import ru.yandex.direct.clickhouse.InsertRecord;
import ru.yandex.direct.utils.Counter;

public class EnumClickHouseType<T extends Enum<T>> extends ClickHouseType<T> {
    private Class<T> tClass;

    public EnumClickHouseType(String enumType, Class<T> clazz) {
        super(((Supplier<String>) () -> {
            Counter counter = new Counter(1);
            return enumType + "("
                    + Stream.of(clazz.getEnumConstants())
                    .map(v -> ClickHouseUtils.quote(v.name()) + '=' + counter.next())
                    .collect(Collectors.joining(", "))
                    + ")";
        }).get());
        this.tClass = clazz;
    }

    @Override
    public T fromClickHouseString(String stringValue) {
        return Enum.valueOf(tClass, stringValue);
    }

    @Override
    public T fromJavaSqlResult(Object value) {
        return fromClickHouseString((String) value);
    }

    @Override
    public void setNextInRecord(InsertRecord record, T value) {
        record.setNext(value.name());
    }

    @Override
    public Object toSqlObject(T value) {
        return value.name();
    }
}
