package ru.yandex.direct.clickhouse.types;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

@ParametersAreNonnullByDefault
public class Float32ClickHouseType extends ClickHouseType<Float> {
    public Float32ClickHouseType() {
        super("Float32");
    }

    @Override
    public Float fromClickHouseString(String stringValue) {
        return Float.parseFloat(stringValue);
    }

    @Nullable
    @Override
    public Float fromJavaSqlResult(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        return (Float) value;
    }

    @Override
    public void setNextInRecord(InsertRecord record, Float value) {
        record.setNext(value);
    }

    @Override
    public Object toSqlObject(Float value) {
        return value;
    }
}
