package ru.yandex.direct.clickhouse.types;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

@ParametersAreNonnullByDefault
public class Float64ClickHouseType extends ClickHouseType<Double> {
    public Float64ClickHouseType() {
        super("Float64");
    }

    @Override
    public Double fromClickHouseString(String stringValue) {
        return Double.parseDouble(stringValue);
    }

    @Nullable
    @Override
    public Double fromJavaSqlResult(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        return (Double) value;
    }

    @Override
    public void setNextInRecord(InsertRecord record, Double value) {
        record.setNext(value);
    }

    @Override
    public Object toSqlObject(Double value) {
        return value;
    }
}
