package ru.yandex.direct.clickhouse.types;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

/**
 * В отличие от {@link BooleanClickHouseType}, использует для хранения тип Int8.
 * Трактует 0 как false, любое другое значение как true.
 * Не подвержен ошибке CLICKHOUSE-3559
 */
@ParametersAreNonnullByDefault
public class IntBooleanClickHouseType extends ClickHouseType<Boolean> {
    public IntBooleanClickHouseType() {
        super("Int8");
    }

    @Nullable
    @Override
    public Boolean fromClickHouseString(@Nonnull String stringValue) {
        return !stringValue.equals("0");
    }

    @Nullable
    @Override
    public Boolean fromJavaSqlResult(@Nullable Object value) {
        return value == null ? null : ((Integer) value != 0);
    }

    @Override
    public void setNextInRecord(InsertRecord record, Boolean value) {
        record.setNext(value ? "1" : "0");
    }

    @Override
    public Object toSqlObject(Boolean value) {
        return value ? 1 : 0;
    }
}
