package ru.yandex.direct.clickhouse.types;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

public class IntegerClickHouseType extends ClickHouseType<Integer> {
    public IntegerClickHouseType(String type) {
        super(type);
    }

    @Override
    public Integer fromClickHouseString(String stringValue) {
        return Integer.parseInt(stringValue);
    }

    @Override
    public Integer fromJavaSqlResult(Object value) {
        return (Integer) value;
    }

    @Override
    public void setNextInRecord(InsertRecord record, Integer value) {
        record.setNext(value);
    }

    @Override
    public Object toSqlObject(Integer value) {
        return value;
    }
}
