package ru.yandex.direct.clickhouse.types;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

public class LongClickHouseType extends ClickHouseType<Long> {
    public LongClickHouseType(String type) {
        super(type);
    }

    @Override
    public Long fromClickHouseString(String stringValue) {
        return Long.parseLong(stringValue);
    }

    @Override
    public Long fromJavaSqlResult(Object value) {
        if (value instanceof Integer) {
            return Long.valueOf((Integer) value);
        }
        return (Long) value;
    }

    @Override
    public void setNextInRecord(InsertRecord record, Long value) {
        record.setNext(value);
    }

    @Override
    public Object toSqlObject(Long value) {
        return value;
    }
}
