package ru.yandex.direct.clickhouse.types;

import java.util.Optional;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

public class OptionalStringClickHouseType extends ClickHouseType<Optional<String>> {
    private final String emptyValue;

    public OptionalStringClickHouseType(String emptyValue) {
        super("String");
        this.emptyValue = emptyValue;
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    @Override
    public void setNextInRecord(InsertRecord record, Optional<String> value) {
        if (value.isPresent()) {
            if (emptyValue.equals(value.get())) {
                throw new IllegalArgumentException(
                        "Value " + value + " is illegal because it represents empty value in clickhouse table."
                );
            }
            record.setNext(value.get());
        } else {
            record.setNext(emptyValue);
        }
    }

    @Override
    public Optional<String> fromClickHouseString(String stringValue) {
        return emptyValue.equals(stringValue) ? Optional.empty() : Optional.of(stringValue);
    }

    @Override
    public Optional<String> fromJavaSqlResult(Object value) {
        if (value == null) {
            return null;
        } else {
            return Optional.of((String) value);
        }
    }

    @Override
    public Object toSqlObject(Optional<String> value) {
        return value.orElse(emptyValue);
    }
}
