package ru.yandex.direct.clickhouse.types;

import ru.yandex.direct.clickhouse.ClickHouseType;
import ru.yandex.direct.clickhouse.InsertRecord;

public class StringClickHouseType extends ClickHouseType<String> {
    public StringClickHouseType() {
        super("String");
    }

    @Override
    public String fromClickHouseString(String stringValue) {
        return stringValue;
    }

    @Override
    public String fromJavaSqlResult(Object value) {
        return (String) value;
    }

    @Override
    public void setNextInRecord(InsertRecord record, String value) {
        record.setNext(value);
    }

    @Override
    public Object toSqlObject(String value) {
        return value;
    }
}
