package ru.yandex.direct.clickhouse.types;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.clickhouse.InsertRecord;

/**
 * Применяется в тех случаях, когда хочется хранить беззнаковые числа, вмещающиеся в 31 бит.
 */
@ParametersAreNonnullByDefault
public class UInt32ClickHouseType extends IntegerClickHouseType {
    public UInt32ClickHouseType() {
        super("UInt32");
    }

    @Override
    public Integer fromJavaSqlResult(Object source) {
        return castToInteger(source);
    }

    public void setNextInRecord(InsertRecord record, Long value) {
        record.setNext(castToInteger(value));
    }

    private Integer castToInteger(Object source) {
        if (source instanceof Integer) {
            return (Integer) source;
        } else if (source instanceof Long) {
            long sourcePlain = (Long) source;
            int result = (int) sourcePlain;
            if (sourcePlain != result) {
                throw new RuntimeException("Integer overflow for field " + this +
                        ": number " + source + " does not fit Integer");
            }
            return result;
        } else {
            throw new RuntimeException("In field " + this + ": object " + source + " can't be converted to integer.");
        }
    }
}
