#!/bin/bash
set -e
OLD_DIR=/etc/clickhouse-server
NEW_DIR=/tmp/clickhouse_conf
CONF_FILE=config.xml

cp --recursive --symbolic-link "$OLD_DIR" "$NEW_DIR"

if [ "$1" == '--no-ipv6' ]; then
    rm "$NEW_DIR/$CONF_FILE"
    sed -e '/<listen_host[^>]*>[^<]*<\/listen_host>/ d' \
        -e '/^<yandex>$/ a<listen_host>0.0.0.0</listen_host>' \
        "$OLD_DIR/$CONF_FILE" > "$NEW_DIR/$CONF_FILE"
fi

exec /usr/bin/clickhouse-server --config="$NEW_DIR/$CONF_FILE"
